chrome.alarms.onAlarm.addListener(function(alarm) {
    KTimer.getAll(function(timers) {
        Object.keys(timers).forEach(function(key) {
            var timer = timers[key];

            if (timer.isExpired()) {
                KTimer.removeTimer({id: timer.tab.id}, function() {
                    chrome.tabs.remove(timer.tab.id, function() {});
                });
            } else {
                var remainsMinutes = timer.remainsMinutes();

                var remainsText = remainsMinutes == 0 ? '<1' : remainsMinutes.toString();
                chrome.browserAction.setBadgeText({tabId: timer.tab.id, text: remainsText});

                if (remainsMinutes < 2) {
                    chrome.notifications.create(
                        timer.tab.id + '',
                        {
                            type: 'basic',
                            iconUrl: "timer-logo-128.png",
                            title: 'Tab [' + truncate(timer.tab.title, 30, '...') + '] will be closed soon',
                            message: '',
                            buttons: [{title: 'Wait another 5 minutes'}]
                        },
                        function(notificationId) {}
                    );
                }
            }
        });

    });
});

chrome.tabs.onRemoved.addListener(function(tabId, removeInfo) {
    KTimer.removeTimer({id: tabId}, function() {});
});

chrome.runtime.onInstalled.addListener(function() {
    chrome.alarms.create("everyMinute", {
        delayInMinutes: 1,
        periodInMinutes: 1
    });

    chrome.notifications.onButtonClicked.addListener(function(notificationId, buttonIndex) {
        chrome.tabs.get(+notificationId, function(tab) {
            if (chrome.runtime.lastError) {
                console.log(chrome.runtime.lastError);
                return;
            }

            KTimer.addTimer(tab, 5, function() {
                chrome.notifications.clear(notificationId, function() {});
            });

        })
    });

});
